insheet using "$input_ext/view_election.csv", clear delimiter("$DELIMITER")
* Austria 11, Netherlands 14, Spain 15, Italy 16, France 17, Denmark 18, Switzerland 20, Belgium 23, Germany 12, Sweden 13
keep if country_name_short=="AUT" | country_name_short=="NLD" | country_name_short=="ESP" | country_name_short=="ITA" | ///
	country_name_short=="FRA" | country_name_short=="DNK" | country_name_short=="CHE" | country_name_short=="BEL" | ///
	country_name_short=="DEU" | country_name_short=="SWE"
g country=11 if country_name_short=="AUT" 
replace country=14 if country_name_short=="NLD" 
replace country=15 if country_name_short=="ESP" 
replace country=16 if country_name_short=="ITA" 
replace country=17 if country_name_short=="FRA" 
replace country=18 if country_name_short=="DNK" 
replace country=20 if country_name_short=="CHE" 
replace country=23 if country_name_short=="BEL" 
replace country=12 if country_name_short=="DEU" 
replace country=13 if country_name_short=="SWE"
* I drop european elections
keep if election_type=="parliament"
sample 1, count by(election_id)
keep country election_date
g date_election=date(election_date, "DMY")
g date_election2=ym(year(date_election), month(date_election))
keep country date_election date_election2
sort country date_election2
save elections, replace


insheet using "$input_ext/view_cabinet.csv", clear delimiter("$DELIMITER")
* Austria 11, Netherlands 14, Spain 15, Italy 16, France 17, Denmark 18, Switzerland 20, Belgium 23, Germany 12, Sweden 13
keep if country_name_short=="AUT" | country_name_short=="NLD" | country_name_short=="ESP" | country_name_short=="ITA" | ///
	country_name_short=="FRA" | country_name_short=="DNK" | country_name_short=="CHE" | country_name_short=="BEL" | ///
	country_name_short=="DEU" | country_name_short=="SWE"
g country=11 if country_name_short=="AUT" 
replace country=14 if country_name_short=="NLD" 
replace country=15 if country_name_short=="ESP" 
replace country=16 if country_name_short=="ITA" 
replace country=17 if country_name_short=="FRA" 
replace country=18 if country_name_short=="DNK" 
replace country=20 if country_name_short=="CHE" 
replace country=23 if country_name_short=="BEL" 
replace country=12 if country_name_short=="DEU" 
replace country=13 if country_name_short=="SWE"
*check
codebook left_right
g nomiss=left_right!=.
egen sum=sum(nomiss) if cabinet_party==1, by(cabinet_id)
tab sum
browse if sum==0
drop sum nomiss
* the only problem is the Monti Government
replace left_right=5 if cabinet_id==983
replace seats=1 if cabinet_id==983

egen mas=max(cabinet_party), by(cabinet_id)
tab mas
drop mas
keep if cabinet_party==1
count
g date_start=date(start_date, "DMY")
keep if year(date_start)>=2000
codebook left_right
g nomiss=left_right!=.
egen sum=sum(nomiss), by(cabinet_id)
egen ssum=sum(cabinet_party), by(cabinet_id)
tab sum ssum
drop sum ssum
egen sseats=sum(seats), by(cabinet_id)
sum sseats, d
replace seats=1 if left_right!=. & cabinet_id==1506
drop sseats
* I get the weighted average of left_right
replace left_right=left_right*seats
collapse (sum) left_right seats (mean) caretaker, by(country country_name election_date date_start cabinet_name cabinet_id)
replace left_right=left_right/seats
sort country_name date_start
sort country date_start
bysort country: g x=_n
xtset country x
g date_end=f.date_start-1
format date_start %td
format date_end %td
order country_name date_start date_end
sort country_name date_start

browse

g date_start2=ym(year(date_start),month(date_start)+1) if day(date_start)>15 & month(date_start)!=12
replace date_start2=ym(year(date_start)+1,1) if day(date_start)>15 & month(date_start)==12
replace date_start2=ym(year(date_start),month(date_start)) if day(date_start)<=15 & month(date_start)!=1
replace date_start2=ym(year(date_start),month(date_start)) if day(date_start)<=15 & month(date_start)==1

g date_end2=ym(year(date_end),month(date_end)) if day(date_end)>=15 & month(date_end)!=12
replace date_end2=ym(year(date_end),12) if day(date_end)>=15 & month(date_end)==12
replace date_end2=ym(year(date_end),month(date_end)-1) if day(date_end)<15 & month(date_end)!=1
replace date_end2=ym(year(date_end)-1,12) if day(date_end)<15 & month(date_end)==1

format date_start2 %tm
format date_end2 %tm

sort country_name date_start2
order country_name date_start date_end date_start2 date_end2
browse
keep country date_start* date_end* cabinet_id left_right caretaker
sort country date_start
save cabinet, replace

use cabinet, clear
sample 1, count by(country)
keep country
expand 17
bysort country: g year=1999+_n
expand 12
count
bysort country year: g month=_n
g date=ym(year,month)
joinby country using cabinet, _merge(_merge)
keep if date>=date_start2 & date<=date_end2
keep if year>=2002
xtset country date
foreach cc in 11 14 15 16 17 18 20 23 12 13 {
	sum date if country==`cc'
	di r(max)-r(min)+1
		}

sum date
g date2=-date+504+683

xtset country date
g from_change_gov=date==date_start2
replace from_change_gov=l.from_change_gov+1 if from_change_gov==0 & l.from_change_gov!=0 & date>=504
xtset country date2
g to_change_gov=date==date_start2
replace to_change_gov=l.to_change_gov+1 if to_change_gov==0 & l.to_change_gov!=0 & date2>=504
g inv_to_change_gov=to_change_gov
g inv_from_change_gov=from_change_gov
replace inv_to_change_gov=0 if inv_to_change_gov>25
replace inv_from_change_gov=0 if inv_from_change_gov>25
replace inv_to_change_gov=-inv_to_change_gov+26 if inv_to_change_gov!=0
replace inv_from_change_gov=-inv_from_change_gov+26 if inv_from_change_gov!=0
egen D_to_change_gov=rowmax(inv_to_change_gov inv_from_change_gov)
xtset country date

drop _merge
g date_election2=date
sort country date_election2
merge 1:1 country date_election2 using elections
drop if _merge==2
g election=_merge==3
drop _merge

xtset country date
g from_elections=election==1
replace from_elections=l.from_elections+1 if from_elections==0 & l.from_elections!=0 & date>=504
xtset country date2
g to_elections=date==election==1
replace to_elections=l.to_elections+1 if to_elections==0 & l.to_elections!=0 & date2>=504
g inv_to_elections=to_elections
g inv_from_elections=from_elections
replace inv_to_elections=0 if inv_to_elections>25
replace inv_from_elections=0 if inv_from_elections>25
replace inv_to_elections=-inv_to_elections+26 if inv_to_elections!=0
replace inv_from_elections=-inv_from_elections+26 if inv_from_elections!=0
egen D_to_elections=rowmax(inv_to_elections inv_from_elections)
xtset country date


keep country date left_right caretaker D_to_change_gov D_to_elections
sort country date
g int_year=year(dofm(date))
g int_month=month(dofm(date))
sort country int_year int_month
save cabinet, replace


